<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
server:
  port: 8080
<#assign zuul=false>
<#if item.getAllPSDataEntities?? && item.getAllPSDataEntities()??>
    <#assign haswfentity=false>
    <#list item.getAllPSDataEntities() as appDataEntity>
        <#assign serviceId="">
        <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
        <#assign appEntity=appDataEntity.name?lower_case>
        <#assign psDataEntity=appDataEntity>
        <#assign systemName=sys.getCodeName()?lower_case>
        <#if psDataEntity.hasPSDEWF()?? && psDataEntity.hasPSDEWF()==true>
            <#assign haswfentity=true>
        </#if>
        <#if psDataEntity.getStorageMode()==4>
            <#comment>serviceApi模式</#comment>
            <#assign serviceId=(psDataEntity.getPSSubSysServiceAPI().getServiceCodeName())!''>
            <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
            <#if serviceId!="">
                <#assign zuul=true>
            </#if>
        </#if>
    </#list>
    <#if haswfentity==true>
        <#assign zuul=true>
    </#if>
    <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
        <#assign zuul=true>
    </#if>
</#if>

<#if zuul==true && item.getAllPSDataEntities?? && item.getAllPSDataEntities()??>
#zuul网关路由设置
zuul:
  routes:
    <#assign haswfentity=false>
    <#list item.getAllPSDataEntities() as appDataEntity>
        <#assign serviceId="">
        <#assign serviceUrl=srfpluralize(appDataEntity.codeName?lower_case)>
        <#assign appEntity=appDataEntity.name?lower_case>
        <#assign psDataEntity=appDataEntity>
        <#assign systemName=sys.getCodeName()?lower_case>
        <#if psDataEntity.hasPSDEWF()?? && psDataEntity.hasPSDEWF()==true>
            <#assign haswfentity=true>
        </#if>
        <#if psDataEntity.getStorageMode()==4>
            <#comment>serviceApi模式</#comment>
            <#assign serviceId=(psDataEntity.getPSSubSysServiceAPI().getServiceCodeName())!''>
            <#assign serviceUrl=srfpluralize(appDataEntity.name?lower_case)>
            <#if serviceId!="">
      ${appEntity}:
        path: /${serviceUrl}/**
        serviceId: ${serviceId}
        stripPrefix: false
            </#if>
        </#if>
    </#list>
    <#if haswfentity==true>
      wfcore:
        path: /wfcore/**
        serviceId: ibzwf-api
        stripPrefix: true
    </#if>
    <#if sys.getPSSystemSetting()?? && sys.getPSSystemSetting().getDataAccCtrlArch()?? && sys.getPSSystemSetting().getDataAccCtrlArch()==1>
      loginv7:
        path: /v7/login
        serviceId: ibzuaa-api
        stripPrefix: false
      uaa:
        path: /uaa/**
        serviceId: ibzuaa-api
        stripPrefix: false
      config:
        path: /config/**
        serviceId: ibzuaa-api
        stripPrefix: false
        <#if sys.getCodeName()!='ibzou' && sys.getCodeName()!='ibzrt'>
      oucore:
        path: /ibzorganizations/**
        serviceId: ibzou-api
        stripPrefix: false
        </#if>
    </#if>
    <#comment>通过设置该参数，避免Zuul转发请求时丢失Authorization请求头信息</#comment>
  sensitive-headers:
    - Cookie,Set-Cookie,Authorization
</#if>